package com.zteits.irain.portal.web.ebochong.send;

import java.io.UnsupportedEncodingException;
import java.util.HashMap;
import java.util.Map;

import com.alibaba.fastjson.JSONObject;

import com.clouds.common.utils.EBoChongAESUtil;
import com.zteits.irain.portal.common.HttpClientTutorial;
import com.zteits.irain.portal.vo.ebochong.send.AddChargeInfoReq;
import com.zteits.irain.portal.vo.ebochong.send.AddChargeInfoRes;
import com.zteits.irain.portal.vo.ebochong.send.AddVehicleReservationReq;
import com.zteits.irain.portal.vo.ebochong.send.AddVehicleReservationRes;
import com.zteits.irain.portal.vo.ebochong.send.GetVehicleChargeReq;
import com.zteits.irain.portal.vo.ebochong.send.GetVehicleChargeRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.web.ebochong.send
 * @Description: 杰商 数据发送 接口
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/6/22   下午4:55
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/6/22      atao          v1.0.0          创建
 */
@Api("杰商下发接口")
@RestController
@RequestMapping("/ebochong")
public class EBoChongSendController {
    @Value("${ebochong.url}")
    private String url;
    @Value("${ebochong.clientCode}")
    private String clientCode;
    @Value("${ebochong.key}")
    private String key;

    private static final Logger logger = LoggerFactory.getLogger(EBoChongSendController.class);

    @ApiOperation("添加预约车辆信息接口")
    @PostMapping("/addVehicleReservation")
    public AddVehicleReservationRes addVehicleReservation(@RequestBody AddVehicleReservationReq req)
        throws UnsupportedEncodingException {
        logger.info("杰商 添加预约车辆信息接口 入参为:req={}", JSONObject.toJSONString(req));
        logger.info("杰商 添加预约车辆信息接口 请求的URL为：url={}", url);
        Map<String, Object> headers = getCommonHeader();
        String data = EBoChongAESUtil.encryptAES(JSONObject.toJSONString(req),key);
        logger.info("杰商 添加预约车辆信息接口 加密后的数据为: data={}",data);
        String result = HttpClientTutorial.httpPostRequest(url, headers, data);
        logger.info("杰商 添加预约车辆信息接口 返回的数据为:result={}",result);
        AddVehicleReservationRes res = JSONObject.parseObject(result, AddVehicleReservationRes.class);
        logger.info("杰商 添加预约车辆信息接口 响应为:res={}", JSONObject.toJSONString(res));
        return res;
    }

    @ApiOperation("获取车辆收费金额")
    @PostMapping("/getVehicleCharge")
    public GetVehicleChargeRes getVehicleCharge(@RequestBody GetVehicleChargeReq req)
        throws UnsupportedEncodingException {
        logger.info("杰商 获取车辆收费金额 入参为:req={}", JSONObject.toJSONString(req));
        logger.info("杰商 获取车辆收费金额 请求的URL为：url={}", url);
        Map<String, Object> headers = getCommonHeader();
        String data = EBoChongAESUtil.encryptAES(JSONObject.toJSONString(req),key);
        logger.info("杰商 获取车辆收费金额 加密后的数据为: data={}",data);
        String result = HttpClientTutorial.httpPostRequest(url, headers, data);
        logger.info("杰商 获取车辆收费金额 返回的数据为:result={}",result);
        GetVehicleChargeRes res = JSONObject.parseObject(result, GetVehicleChargeRes.class);
        logger.info("杰商 获取车辆收费金额 响应为:res={}", JSONObject.toJSONString(res));

        return res;
    }

    @ApiOperation("添加收费信息")
    @PostMapping("/addChargeInfo")
    public AddChargeInfoRes addChargeInfo(@RequestBody AddChargeInfoReq req) throws UnsupportedEncodingException {
        logger.info("杰商 添加收费信息 入参为:req={}", JSONObject.toJSONString(req));
        logger.info("杰商 添加收费信息 请求的URL为：url={}", url);
        Map<String, Object> headers = getCommonHeader();
        String data = EBoChongAESUtil.encryptAES(JSONObject.toJSONString(req),key);
        logger.info("杰商 添加收费信息 加密后的数据为: data={}",data);
        String result = HttpClientTutorial.httpPostRequest(url, headers, data);
        logger.info("杰商 添加收费信息 返回的数据为:result={}",result);
        AddChargeInfoRes res = JSONObject.parseObject(result, AddChargeInfoRes.class);
        logger.info("杰商 添加收费信息 响应为:res={}", JSONObject.toJSONString(res));

        return res;
    }

    /**
     * 获取公共请求头
     *
     * @return
     */
    private Map<String, Object> getCommonHeader() {
        Map<String, Object> maps = new HashMap<>();
        maps.put("ClientCode", clientCode);
        maps.put("Content-Type", "application/json");
        return maps;
    }

}
