package com.zteits.irain.portal.web.ebochong.receive;

import java.io.BufferedReader;
import java.io.IOException;

import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import com.alibaba.fastjson.JSONObject;

import com.clouds.common.utils.EBoChongAESUtil;
import com.clouds.common.utils.ResultUtils;
import com.xiaoleilu.hutool.date.DateUtil;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.param.FreeBerthNumUpdateByFreeBerthNumRequest;
import com.zteits.clouds.api.dto.park.param.InParkingRequest;
import com.zteits.clouds.api.dto.park.param.InterfaceLogSaveRequest;
import com.zteits.clouds.api.dto.park.param.OutParkingRequest;
import com.zteits.clouds.api.dto.park.param.QueryParkLotInfoByPkNoRequest;
import com.zteits.clouds.api.service.park.IInOutParkingService;
import com.zteits.clouds.api.service.park.InterfaceLogService;
import com.zteits.clouds.api.service.park.ParkFreeBerthService;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.irain.portal.constant.ParkConstant.InterfaceLog;
import com.zteits.irain.portal.constant.ParkConstant.InterfaceLog.Type;
import com.zteits.irain.portal.vo.ebochong.EBoChongEnum;
import com.zteits.irain.portal.vo.ebochong.receive.ChargeListReq;
import com.zteits.irain.portal.vo.ebochong.receive.ChargeListRes;
import com.zteits.irain.portal.vo.ebochong.receive.CommonRes;
import com.zteits.irain.portal.vo.ebochong.receive.HandledVehicleInfoReq;
import com.zteits.irain.portal.vo.ebochong.receive.HandledVehicleInfoRes;
import com.zteits.irain.portal.vo.ebochong.receive.RemainingInfoReq;
import com.zteits.irain.portal.vo.ebochong.receive.RemainingInfoRes;
import com.zteits.irain.portal.vo.ebochong.receive.ResendVehicleInfoReq;
import com.zteits.irain.portal.vo.ebochong.receive.ResendVehicleInfoRes;
import com.zteits.irain.portal.vo.ebochong.receive.UnhandledVehicleInfoReq;
import com.zteits.irain.portal.vo.ebochong.receive.UnhandledVehicleInfoRes;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.util.StringUtils;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.web.ebochong.receive
 * @Description: 易泊冲 数据接收 接口
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/6/22   下午4:57
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/6/22      atao          v1.0.0          创建
 */
@Api(value = "杰商上报接口")
@RestController
@RequestMapping("/ebochong")
public class EBoChongReceiveController {

    @Value("${project.syscode}")
    private String sysCode;

    @Autowired
    private ParkFreeBerthService parkFreeBerthService;
    @Autowired
    private IInOutParkingService iInOutParkingService;
    @Autowired
    private ParkingLotQueryService parkingLotQueryService;

    @Autowired
    private InterfaceLogService interfaceLogService;

    @Value("${ebochong.key}")
    private String key;

    private static final Logger logger = LoggerFactory.getLogger(EBoChongReceiveController.class);

    @ApiOperation("发送未处理过车信息")
    @PostMapping("/SendUnhandledVehicleInfo")
    public void SendUnhandledVehicleInfo(HttpServletRequest request, HttpServletResponse response) {
        String data = getRequestBody(request);
        logger.info("===发送未处理过车信息 data={}", data);
        try {
            data = EBoChongAESUtil.decryptAES(data, key);
        } catch (Exception e) {
            e.printStackTrace();
        }
        logger.info("===发送未处理过车信息 解密后data={}", data);
        UnhandledVehicleInfoReq req = JSONObject.parseObject(data, UnhandledVehicleInfoReq.class);
        logger.info("===发送未处理过车信息 格式化对象 req={}", JSONObject.toJSONString(req));

        UnhandledVehicleInfoRes res = new UnhandledVehicleInfoRes();
        res.setCommand(EBoChongEnum.COMMAND_GO.val());
        res.setCreditLimit("100");
        res.setMessage("测试");
        logger.info("===发送未处理过车信息 res={}", JSONObject.toJSONString(res));
        setResponse(response, res);
    }

    @ApiOperation("发送已处理过车信息")
    @PostMapping("/SendHandledVehicleInfo")
    public void SendHandledVehicleInfo(HttpServletRequest request, HttpServletResponse response) {

        BaseInfo baseInfo = new BaseInfo();
        String requestId = baseInfo.getRequestId();
        String entryReq = getRequestBody(request);
        logger.info("===发送已处理过车信息 data={}", entryReq);
        String data = EBoChongAESUtil.decryptAES(entryReq, key);
        logger.info("===发送已处理过车信息 解密后data={}", data);
        HandledVehicleInfoReq req = JSONObject.parseObject(data, HandledVehicleInfoReq.class);
        logger.info("===发送已处理过车信息 格式化对象 req={}", JSONObject.toJSONString(req));

        //记录日志
        InterfaceLogSaveRequest logSaveRequest = new InterfaceLogSaveRequest(sysCode, baseInfo,
            InterfaceLog.Type.TYPE_IN_PARKING, data, InterfaceLog.FromType.JIESHANG);
        //设置未解密的字符串
        logSaveRequest.setEncryptParam(entryReq);
        //设置未同步
        logSaveRequest.setSyncStatus(1);

        if (req.getCarOut() == 0) {
            logSaveRequest.setType(InterfaceLog.Type.TYPE_IN_PARKING);
            //入场
            InParkingRequest inParkingRequest = new InParkingRequest();
            inParkingRequest.setSysCode("123456");
            inParkingRequest.setCardno(req.getCardNo());
            inParkingRequest.setFreeBerths(req.getRemaining());
            inParkingRequest.setFromType(4);
            inParkingRequest.setInArmCode("");
            inParkingRequest.setInTime(DateUtil.parse(req.getInTime()));
            inParkingRequest.setParkCode(req.getParkIndex());
            inParkingRequest.setRecordId(req.getUuid());
            inParkingRequest.setPlNo(req.getParkIndex());
            inParkingRequest.setVplNumber(req.getPlateNo());
            inParkingRequest.setPlName(queryParkingLotNameByPlNo(req.getParkIndex()));
            logger.info("===调用dubbo服务停车记录保存 dubboReq={}", JSONObject.toJSONString(inParkingRequest));
            BizResult<Long> bizResult = iInOutParkingService.SaveIRainInParking(inParkingRequest);
            logger.info("===调用dubbo服务停车记录保存 dubboRes={}", JSONObject.toJSONString(bizResult));
        } else {
            logSaveRequest.setType(Type.TYPE_OUT_PARKING);
            //出场
            OutParkingRequest outParkingRequest = new OutParkingRequest();
            outParkingRequest.setSysCode("123456");
            outParkingRequest.setCardno(req.getCardNo());
            outParkingRequest.setFreeBerths(req.getRemaining());
            outParkingRequest.setFromType(4);
            outParkingRequest.setInTime(DateUtil.parse(req.getInTime()));
            outParkingRequest.setParkCode(req.getParkIndex());
            outParkingRequest.setRecordId(req.getUuid());
            outParkingRequest.setPlNo(req.getParkIndex());
            outParkingRequest.setVplNumber(req.getPlateNo());
            outParkingRequest.setPlName(queryParkingLotNameByPlNo(req.getParkIndex()));
            logger.info("===调用dubbo服务停车记录保存 dubboReq={}", JSONObject.toJSONString(outParkingRequest));
            BizResult<Long> bizResult = iInOutParkingService.SaveIRainOutParking(outParkingRequest);
            logger.info("===调用dubbo服务停车记录保存 dubboRes={}", JSONObject.toJSONString(bizResult));
        }

        HandledVehicleInfoRes res = new HandledVehicleInfoRes();
        res.setMessage("测试");
        res.setCode(EBoChongEnum.CODE_SUCCESS.val());
        logger.info("===发送已处理过车信息 res={}", JSONObject.toJSONString(res));

        try {
            FreeBerthNumUpdateByFreeBerthNumRequest dubboReq = new FreeBerthNumUpdateByFreeBerthNumRequest();
            dubboReq.setPlNo(req.getParkIndex());
            dubboReq.setFreeBerthNum(req.getRemaining());
            dubboReq.setSysCode("123456");
            logger.info("===调用dubbo服务更新空余车位信息 dubboReq={}", JSONObject.toJSONString(dubboReq));
            BizResult<Integer> result = parkFreeBerthService.updateFreeBerthNumByFreeBerthNum(dubboReq);
            logger.info("===调用dubbo服务更新空余车位信息 dubboRes={}", JSONObject.toJSONString(result));
            //保存接口日志
            interfaceLogService.SaveInterfaceLog(logSaveRequest);
        } catch (Exception e) {
            logger.info("===更新空余车位数捕获异常", e);
        }

        setResponse(response, res);

    }

    @ApiOperation("发送剩余停车位信息")
    @PostMapping("/SendRemainingInfo")
    public void SendRemainingInfo(HttpServletRequest request, HttpServletResponse response) {
        String data = getRequestBody(request);
        logger.info("===发送剩余停车位信息 data={}", data);
        data = EBoChongAESUtil.decryptAES(data, key);
        logger.info("===发送剩余停车位信息 解密后data={}", data);
        RemainingInfoReq req = JSONObject.parseObject(data, RemainingInfoReq.class);
        logger.info("===发送剩余停车位信息 格式化对象 req={}", JSONObject.toJSONString(req));
        FreeBerthNumUpdateByFreeBerthNumRequest dubboReq = new FreeBerthNumUpdateByFreeBerthNumRequest();
        dubboReq.setPlNo(req.getParkIndex());
        dubboReq.setFreeBerthNum(req.getRemaining());
        dubboReq.setSysCode("123456");
        logger.info("===调用dubbo服务更新空余车位信息 dubboReq={}", JSONObject.toJSONString(dubboReq));
        BizResult<Integer> result = parkFreeBerthService.updateFreeBerthNumByFreeBerthNum(dubboReq);
        logger.info("===调用dubbo服务更新空余车位信息 dubboRes={}", JSONObject.toJSONString(result));
        RemainingInfoRes res = new RemainingInfoRes();
        res.setMessage("测试");
        res.setCode(EBoChongEnum.CODE_SUCCESS.val());
        logger.info("===发送剩余停车位信息 res={}", JSONObject.toJSONString(res));
        setResponse(response, res);
    }

    @ApiOperation("发送停车场对账信息")
    @PostMapping("/SendChargeList")
    public void SendChargeList(HttpServletRequest request, HttpServletResponse response) {
        String data = getRequestBody(request);
        logger.info("===发送停车场对账信息 data={}", data);
        data = EBoChongAESUtil.decryptAES(data, key);
        logger.info("===发送停车场对账信息 解密后data={}", data);
        ChargeListReq req = JSONObject.parseObject(data, ChargeListReq.class);
        logger.info("===发送停车场对账信息 格式化对象 req={}", JSONObject.toJSONString(req));

        ChargeListRes res = new ChargeListRes();
        res.setMessage("测试");
        res.setCode(EBoChongEnum.CODE_SUCCESS.val());
        logger.info("===发送停车场对账信息 res={}", JSONObject.toJSONString(res));
        setResponse(response, res);
    }

    @ApiOperation("补发过车信息")
    @PostMapping("/ResendVehicleInfo")
    public void ResendVehicleInfo(HttpServletRequest request, HttpServletResponse response) {
        String data = getRequestBody(request);
        logger.info("===补发过车信息 data={}", data);
        data = EBoChongAESUtil.decryptAES(data, key);
        logger.info("===补发过车信息 解密后data={}", data);
        ResendVehicleInfoReq req = JSONObject.parseObject(data, ResendVehicleInfoReq.class);
        logger.info("===补发过车信息 格式化对象 req={}", JSONObject.toJSONString(req));

        ResendVehicleInfoRes res = new ResendVehicleInfoRes();
        res.setSendNo(req.getSendNo());
        res.setMessage("测试");
        res.setCode(EBoChongEnum.CODE_SUCCESS.val());
        logger.info("===补发过车信息 res={}", JSONObject.toJSONString(res));
        setResponse(response, res);
    }

    private String getRequestBody(HttpServletRequest request) {
        StringBuffer sb = new StringBuffer();
        String line;
        BufferedReader reader = null;
        try {
            reader = request.getReader();
            while ((line = reader.readLine()) != null) {
                sb.append(line);
            }
        } catch (IOException e) {
            logger.info("杰商   接收数据报错=====");
            e.printStackTrace();
        }

        String jbstring = sb.toString();
        return jbstring;
    }

    private void setResponse(HttpServletResponse response, CommonRes res) {
        try {
            String jsonData = JSONObject.toJSONString(res);
            String data = EBoChongAESUtil.encryptAES(jsonData, key).toUpperCase();
            logger.info("====接收数据响应加密数据为:encryptData=" + data);
            response.setCharacterEncoding("UTF-8");
            response.getWriter().write(data);
        } catch (IOException e) {
            e.printStackTrace();
        }
    }

    private String queryParkingLotNameByPlNo(String plNo) {
        if (StringUtils.isEmpty(plNo)) {
            return "";
        }
        QueryParkLotInfoByPkNoRequest request = new QueryParkLotInfoByPkNoRequest();
        request.setPklNo(plNo);
        request.setSysCode("123456");

        BizResult<ParkingLotDTO> result = parkingLotQueryService.QueryParkingLotByPkNo(request);
        if (ResultUtils.isSuccess(result)) {
            return result.getData().getPlName();
        } else {
            return "";
        }
    }

    public static void main(String[] args) {
        String key = "2xJLZAlyolvMMz4+c/8nRA==";
        String str = "{\"plateNo\":\"粤PME680\",\"cardNo\":\"\",\"carType\":0,\"parkIndex\":\"001\","
            + "\"entranceIndex\":\"001\",\"passTime\":\"2016-09-01 23:12:34 \",\"inTime\":\"2016-09-01 23:12:34 \","
            + "\"carOut\":0,\"vehicleUrl\":\"\",\"receivable\":0,\"uuid\":\"900150983CD24FB0D6963F7D28E17F72\","
            + "\"payType\":0}";

        str = EBoChongAESUtil.encryptAES(str, key);
        System.out.println(str);
    }

}
