package com.zteits.irain.portal.web;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.clouds.common.cache.park.ParkFreeBerthsCacheUtil;
import com.clouds.common.web.vo.BizResultVO;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.dto.park.param.RefreshParkCacheRequest;
import com.zteits.clouds.api.dto.sys.param.RefreshSysCacheRequest;
import com.zteits.clouds.api.service.park.RefreshParkCacheService;
import com.zteits.clouds.api.service.sys.RefreshSysCacheService;
import com.zteits.irain.portal.service.impl.induction.InductionServiceImpl;
import com.zteits.irain.portal.service.interfaces.induction.InductionService;
import com.zteits.irain.portal.service.interfaces.induction.param.DoLevelTwoAndThreeInductionReleaseBatchRequest;
import com.zteits.irain.portal.service.interfaces.induction.param.InductionRelease;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

/**
 * 刷新缓存
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: RefreshCacheController.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年7月10日   下午2:42:04 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年7月10日      zhaowg              v1.0.0               创建
 */
@Api(value="刷新缓存",description="刷新缓存")
@RestController
public class RefreshCacheController{
	private static final Logger logger = LoggerFactory.getLogger(RefreshCacheController.class);
	
	@Autowired
	private RefreshParkCacheService refreshParkCacheService;
	@Autowired
	private RefreshSysCacheService refreshSysCacheService ;
	@Autowired
	private InductionService inductionService;
	
	@ApiOperation(value="刷新PARK缓存")
	@PostMapping("refreshParkCache")
	public BizResultVO<String> RefreshParkCacheService(@RequestParam @ApiParam("-1：全部刷新；2：刷新停车场信息；3：刷新经纬度信息；4：刷新空闲车位信息;5:刷新艾润停车场编号对应关系")Integer type){
		RefreshParkCacheRequest request = new RefreshParkCacheRequest();
		request.setSysCode("PARK");
		request.setType(type);
		BizResult<String> bizResult = refreshParkCacheService.refreshCache(request );
		return new BizResultVO<String>(bizResult);
		
	}
	@ApiOperation(value="刷新SYS缓存")
	@PostMapping("refreshSysCache")
	public BizResultVO<String> RefreshSysCacheService(@RequestParam @ApiParam("-1：全部刷新；1：刷新字典表")Integer type){
		RefreshSysCacheRequest request = new RefreshSysCacheRequest();
		request.setSysCode("PARK");
		request.setType(type);
		BizResult<String> bizResult = refreshSysCacheService.refreshSysCache(request );
		return new BizResultVO<String>(bizResult);
	}
	
	@ApiOperation("更新空闲车位数")
	@PostMapping("updateFreeBerths")
	public BizResultVO<Integer> UpdateFreeBerths(@RequestParam @ApiParam("停车场编号") String plNo,
			@RequestParam @ApiParam("空闲车位数")Integer freeBerths){
		logger.info("更新空闲车位数，车位编码："+plNo+"  空闲车位数："+freeBerths);
		ParkFreeBerthsCacheUtil.setFreeBerthsByPlNo(plNo, freeBerths);
		DoLevelTwoAndThreeInductionReleaseBatchRequest releaseBatchRequest = new DoLevelTwoAndThreeInductionReleaseBatchRequest();
        List<InductionRelease> list = new ArrayList<>();
        //传固定值
        InductionRelease inductionRelease = new InductionRelease();
        inductionRelease.setOwner_code("1001");
        inductionRelease.setRange_code(plNo);
        inductionRelease.setBerth_left(String.valueOf(freeBerths));
        inductionRelease.setParking_code(plNo);
        list.add(inductionRelease);
        releaseBatchRequest.setJsonStr(list);
		BizResultVO<?> bizResultVO = inductionService.doLevelTwoAndThreeInductionReleaseBatch(releaseBatchRequest );
		//查询空闲车位数
		Integer integer = ParkFreeBerthsCacheUtil.getFreeBerthsByPlNo(plNo);
		return new BizResultVO<Integer>().setData(integer);
		
	}
}
