package com.zteits.irain.portal.web;

import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import com.clouds.common.web.vo.BizResultVO;
import com.zteits.irain.portal.service.interfaces.induction.InductionService;
import com.zteits.irain.portal.service.interfaces.induction.param.DoLevelTwoAndThreeInductionReleaseBatchRequest;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
@Api(value = "诱导服务",description="诱导服务")
@RestController
@RequestMapping("induction")
public class InductionController {
	@Autowired
	private InductionService inductionService;
	
	@ApiOperation("二级、三级诱导批量发布")
	@PostMapping("doLevelTwoAndThreeInductionReleaseBatch")
	public BizResultVO<?> doLevelTwoAndThreeInductionReleaseBatch(@RequestBody DoLevelTwoAndThreeInductionReleaseBatchRequest request){
		BizResultVO<?> bizResultVO = inductionService.doLevelTwoAndThreeInductionReleaseBatch(request);
		return bizResultVO;
	}
	
	@ApiOperation("一级诱导发布回显")
	@PostMapping("showLevelOneInductionRelease")
	public BizResultVO<?> showLevelOneInductionRelease(@ApiParam("诱导设备编号")@RequestParam String  eqpCode){
		BizResultVO<?> bizResultVO = inductionService.showLevelOneInductionRelease(eqpCode);
		return bizResultVO;
	}
}
