package com.zteits.irain.portal.vo.parkinglotdatacenter.guide;

import java.util.ArrayList;
import java.util.List;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.vo.parkinglotdatacenter.guide
 * @Description:
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/7/11   下午3:33
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/7/11      atao          v1.0.0          创建
 */
public class SecondGuideInfoVO extends GuideInfoVO {

    /**
     * 二级诱导屏详细信息
     */
    List<GuideDetail> guideInfos;

    public List<GuideDetail> getGuideInfos() {
        return guideInfos;
    }

    public void setGuideInfos(List<GuideDetail> guideInfos) {
        this.guideInfos = guideInfos;
    }

    public void addGuideDetail(String plNo, String plName, Integer freeNum, Integer guidePoint) {
        if (null == guideInfos) {
            guideInfos = new ArrayList<>();
        }
        GuideDetail guideDetail = new GuideDetail(plNo, plName, freeNum, guidePoint);
        guideInfos.add(guideDetail);

    }

}

class GuideDetail {

    /**
     * 停车场编码
     */
    private String plNo;

    /**
     * 停车场名称
     */
    private String plName;
    /**
     * 空余车位数
     */
    private Integer freeNum;

    /**
     * 诱导指向
     */
    private Integer guidePoint;

    public GuideDetail() {
    }

    public GuideDetail(String plNo, String plName, Integer freeNum, Integer guidePoint) {
        this.plNo = plNo;
        this.plName = plName;
        this.freeNum = freeNum;
        this.guidePoint = guidePoint;
    }

    public String getPlNo() {
        return plNo;
    }

    public void setPlNo(String plNo) {
        this.plNo = plNo;
    }

    public String getPlName() {
        return plName;
    }

    public void setPlName(String plName) {
        this.plName = plName;
    }

    public Integer getFreeNum() {
        return freeNum;
    }

    public void setFreeNum(Integer freeNum) {
        this.freeNum = freeNum;
    }

    public Integer getGuidePoint() {
        return guidePoint;
    }

    public void setGuidePoint(Integer guidePoint) {
        this.guidePoint = guidePoint;
    }
}


