package com.zteits.irain.portal.vo.parkinglotdatacenter.guide;

import java.util.ArrayList;
import java.util.List;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.vo.parkinglotdatacenter.guide
 * @Description: 一级诱导展示信息
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/7/11   下午3:27
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/7/11      atao          v1.0.0          创建
 */
public class FirstGuideInfoVO extends GuideInfoVO {
    /**
     * 一级诱导展示图片路径
     */
    private String filePath;

    private List<GuideFirstConfigDetail> configs;

    public String getFilePath() {
        return filePath;
    }

    public void setFilePath(String filePath) {
        this.filePath = filePath;
    }

    public List<GuideFirstConfigDetail> getConfigs() {
        return configs;
    }

    public void setConfigs(
        List<GuideFirstConfigDetail> configs) {
        this.configs = configs;
    }

    public void setConfigs(String plNo, Integer plNameHeight, Integer plNameWidth, Integer freeHeight,
        Integer freeWidth, Integer freeNum, Integer allBerthNum) {
        if (null == configs) {
            configs = new ArrayList<>();
        }
        configs.add(new GuideFirstConfigDetail(plNo, plNameHeight, plNameWidth, freeHeight,
            freeWidth, freeNum, allBerthNum));
    }

    class GuideFirstConfigDetail {
        public GuideFirstConfigDetail(String plNo, Integer plNameHeight, Integer plNameWidth, Integer freeHeight,
            Integer freeWidth, Integer freeNum, Integer allBerthNum) {
            this.plNo = plNo;
            this.plNameHeight = plNameHeight;
            this.plNameWidth = plNameWidth;
            this.freeHeight = freeHeight;
            this.freeWidth = freeWidth;
            this.freeNum = freeNum;
            this.allBerthNum = allBerthNum;
        }

        /**
         * 所属停车场编码.
         */
        private String plNo;

        /**
         * 距离左上角顶点 停车场名称高度 单位:像素.
         */
        private Integer plNameHeight;

        /**
         * 距离左上角顶点 停车场名称宽度 单位:像素.
         */
        private Integer plNameWidth;

        /**
         * 距离左上角顶点 空余停车位高度 单位:像素.
         */
        private Integer freeHeight;

        /**
         * 距离左上角顶点 空余停车位宽度 单位:像素.
         */
        private Integer freeWidth;

        /**
         * 空余车位数
         */
        private Integer freeNum;

        /**
         * 停车场停车位总量
         */
        private Integer allBerthNum;

        public String getPlNo() {
            return plNo;
        }

        public void setPlNo(String plNo) {
            this.plNo = plNo;
        }

        public Integer getPlNameHeight() {
            return plNameHeight;
        }

        public void setPlNameHeight(Integer plNameHeight) {
            this.plNameHeight = plNameHeight;
        }

        public Integer getPlNameWidth() {
            return plNameWidth;
        }

        public void setPlNameWidth(Integer plNameWidth) {
            this.plNameWidth = plNameWidth;
        }

        public Integer getFreeHeight() {
            return freeHeight;
        }

        public void setFreeHeight(Integer freeHeight) {
            this.freeHeight = freeHeight;
        }

        public Integer getFreeWidth() {
            return freeWidth;
        }

        public void setFreeWidth(Integer freeWidth) {
            this.freeWidth = freeWidth;
        }

        public Integer getFreeNum() {
            return freeNum;
        }

        public void setFreeNum(Integer freeNum) {
            this.freeNum = freeNum;
        }

        public Integer getAllBerthNum() {
            return allBerthNum;
        }

        public void setAllBerthNum(Integer allBerthNum) {
            this.allBerthNum = allBerthNum;
        }
    }
}
