package com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic
 * @Description:
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/6/27   下午4:14
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/6/27      atao          v1.0.0          创建
 */
public class CustIncomeTotalParkVO implements Serializable {

    /**
     * 应收金额总计（元）＝待支付＋已支付总金额（order_total_fee）.
     */
    private String amountDueTotal;

    /**
     * 逃逸金额.
     */
    private String escapeAmount;

    /**
     * 实收金额总计（元）＝已支付／已完成总金额（order_total_fee）.
     */
    private String payedTotalAmount;

    /**
     * 环形数据
     */
    private List<LoopData> loopDatas;

    public void setLoopData(Integer type, String zb) {
        getLoopDatas().add(new LoopData(type, zb));
    }

    public String getAmountDueTotal() {
        return amountDueTotal;
    }

    public void setAmountDueTotal(String amountDueTotal) {
        this.amountDueTotal = amountDueTotal;
    }

    public String getEscapeAmount() {
        return escapeAmount;
    }

    public void setEscapeAmount(String escapeAmount) {
        this.escapeAmount = escapeAmount;
    }

    public String getPayedTotalAmount() {
        return payedTotalAmount;
    }

    public void setPayedTotalAmount(String payedTotalAmount) {
        this.payedTotalAmount = payedTotalAmount;
    }

    public List<LoopData> getLoopDatas() {
        if (null == loopDatas) {
            loopDatas = new ArrayList<>();
        }
        return loopDatas;
    }

    public void setLoopDatas(List<LoopData> loopDatas) {
        this.loopDatas = loopDatas;
    }

    class LoopData implements Serializable {
        public LoopData(Integer type, String zb) {
            this.type = type;
            this.zb = zb;
        }

        //类型
        private Integer type;
        //占比
        private String zb;

        public Integer getType() {
            return type;
        }

        public void setType(Integer type) {
            this.type = type;
        }

        public String getZb() {
            return zb;
        }

        public void setZb(String zb) {
            this.zb = zb;
        }
    }

}
