package com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;

/**
 * Copyright: Copyright (c) 2017  zteits
 *
 * @ClassName: com.zteits.irain.portal.vo.parkinglotcloudplatform.datastatistic
 * @Description:
 * @version: v1.0.0
 * @author: atao
 * @date: 2017/6/22   下午5:33
 * Modification History:
 * Date         Author          Version      Description
 * ---------------------------------------------------------*
 * 2017/6/22      atao          v1.0.0          创建
 */
public class CustIncomeForPayTypeResVO implements Serializable {
    /**
     * X轴展示数据
     */

    private List<String> xAxisData;
    /**
     * 图标标题头
     */
    private List<String> legendData;

    /**
     * 具体数据
     */
    private List<ChildData> series;

    public List<String> getxAxisData() {
        if (null == xAxisData) {
            xAxisData = new ArrayList<>();
        }
        return xAxisData;
    }

    public void setxAxisData(List<String> xAxisData) {
        this.xAxisData = xAxisData;
    }

    public List<String> getLegendData() {
        if (null == legendData) {
            legendData = new ArrayList<>();
        }
        return legendData;
    }

    public void setLegendData(List<String> legendData) {
        this.legendData = legendData;
    }

    public List<ChildData> getSeries() {
        if (null == series) {
            series = new ArrayList<>();
        }
        return series;
    }

    public void setSeries(
        List<ChildData> series) {
        this.series = series;
    }


    public void addLegendData(String... legendDatas){
        for(String str :legendDatas){
            getLegendData().add(str);
        }
    }

    public void addXAxisData(String strig){
        getxAxisData().add(strig);
    }

    public void addChildData(String name, List<String> datas) {
        ChildData childData = new ChildData();
        childData.setName(name);
        childData.getData().addAll(datas);
        getSeries().add(childData);
    }

    private class ChildData implements Serializable {
        /**
         * 对应标题头的名称
         */
        private String name;
        /**
         * 对应标题头的数据集合
         */
        private List<String> data;

        public String getName() {
            return name;
        }

        public void setName(String name) {
            this.name = name;
        }

        public List<String> getData() {
            if (null == data) {
                data = new ArrayList<>();
            }
            return data;
        }

        public void setData(List<String> data) {
            this.data = data;
        }
    }

}
