package com.zteits.irain.portal.service.interfaces.parklotidleberths;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.zteits.clouds.api.dto.park.dto.TabParkinglotDTO;

/**
 * 停车场空闲车位数
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: ParkLotIdleBerths.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年5月25日   上午10:11:09 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年5月25日      zhaowg              v1.0.0               创建
 */
public interface ParkLotIdleBerthsService {
	/**
	 * 通过停车场编号查询空闲车位信息(临时演示使用)
	 * @param parkNos
	 * @return map key为停车场编号，value为对应的停车场信息
	 * 2017年5月25日 zhaowg
	 */
	@Deprecated
	Map<String, TabParkinglotDTO> getIdleBerthFromRedisByParkNos(List<String> parkNos);
	
	/**
	 * 通过停车场编号更新空闲车位信息
	 * @param inoutTime 进出场时间
	 * @param plNo 自己内部停车场编号
	 * @param type 类型：1：进场；2：出场
	 * @param fromType  1：艾润；2：青岛
	 * @param freeBerths 空闲车位数，来源为青岛时，直接将空闲车位数替换为freeBerths
	 * @return 更新后的空闲车位数
	 */
	int updateAndGetIdleBerthByParkNo(Date inoutTime,String plNo,Integer type,Integer fromType,Integer freeBerths);
	
	
}
