package com.zteits.irain.portal.service.impl.parklotidleberths;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.cache.park.ParkFreeBerthsCacheUtil;
import com.clouds.common.cache.park.ParkingLotCacheUtil;
import com.clouds.common.cache.sys.SysCodeValueCacheUtil;
import com.clouds.common.constants.CodeValKindEnum;
import com.clouds.common.constants.RedisKeyEnum;
import com.clouds.common.redis.RedisCacheUtil;
import com.clouds.common.utils.ResultUtils;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.dto.TabParkinglotDTO;
import com.zteits.clouds.api.dto.park.param.FreeBerthNumUpdateByFreeBerthNumRequest;
import com.zteits.clouds.api.dto.park.param.FreeBerthNumUpdateByInOutTypeRequest;
import com.zteits.clouds.api.service.park.ParkFreeBerthService;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.service.interfaces.parklotidleberths.ParkLotIdleBerthsService;
@Component
public class ParkLotIdleBerthsServiceImpl implements ParkLotIdleBerthsService {
	
	private static final Logger logger = LoggerFactory.getLogger(ParkLotIdleBerthsServiceImpl.class);
	
	@Value("${project.syscode}")
	private String sysCode;
	@Autowired
	private ParkFreeBerthService parkFreeBerthService;
	@Autowired
	private ParkingLotQueryService parkingLotQueryService;
	@Autowired
	private RedisCacheUtil redisCacheUtil;
	
	@Override
	@Deprecated
	public Map<String, TabParkinglotDTO> getIdleBerthFromRedisByParkNos(List<String> parkNos) {
		Map<String, TabParkinglotDTO> result = new HashMap<>();
		BaseInfo info = new BaseInfo();
		//从缓存中获取
		for (String plNo : parkNos) {
			ParkingLotDTO parkingLotDTO = ParkingLotCacheUtil.getParkLotByPlNo(plNo);
			if(parkingLotDTO==null){
				continue;
			}
			TabParkinglotDTO tabdto = new TabParkinglotDTO();
			tabdto.setPklNo(parkingLotDTO.getPlNo());
			tabdto.setPklName(parkingLotDTO.getPlName());
			//获取空闲车位数
			Integer idleberths = ParkFreeBerthsCacheUtil.getFreeBerthsByPlNo(parkingLotDTO.getPlNo());
			tabdto.setIdleberths(idleberths);
			result.put(parkingLotDTO.getPlNo(), tabdto);
		}
		logger.info("["+info.getRequestId()+"]开始通过key获取停车场信息结束");
		return result;
	}

	@Override
	public int updateAndGetIdleBerthByParkNo(Date inoutTime,String plNo, Integer type, Integer fromType,Integer freeBerths) {
		logger.info("开始通过key："+plNo+" 更新空闲车位，类型："+type+"(1:进场；2：出场),来源："+fromType+"(1:艾润；2：青岛)");
/*		logger.info("进/出场时间："+DateUtil.getDateString(inoutTime, DateUtil.YYYYMMDDHHMMSS)+",当前时间："+DateUtil.getDateString(DateUtil.YYYYMMDDHHMMSS));
		Calendar inOutCalendTime = Calendar.getInstance();
		inOutCalendTime.setTime(inoutTime);
		Calendar currentTime = Calendar.getInstance();
		//当前时间-30分钟（防止艾润网络延迟上报）
		currentTime.add(Calendar.MINUTE, -30);
		if(inOutCalendTime.before(currentTime)){
			logger.info("进/出场时间和当前时间误差大于1小时，不更新空闲车位数");
			return ParkFreeBerthsCacheUtil.getFreeBerthsByPlNo(plNo);
		}*/
		
		Integer idleberth = 0;
		try{
			freeBerths = freeBerths==null?0:freeBerths;
			//更新redis中空闲车位数，返回当前总的空闲车位数
			idleberth = updateRedisFreeBerthNum(type, plNo,fromType,freeBerths);
			
			//向Redis消息队列发送空闲车位数
			ParkingLotDTO parkingLotDTO = ParkingLotCacheUtil.getParkLotByPlNo(plNo);
			//判断停车场是否为赤峰
			if(parkingLotDTO!=null && parkingLotDTO.getPlCityId()==ParkConstant.CityId.CHIFENG){
				JSONObject jsonObject = new JSONObject();
				//空闲车位数
				jsonObject.put("freeBerths", idleberth);
				//停车场编号
				jsonObject.put("plNo", plNo);
				redisCacheUtil.convertAndSend(RedisKeyEnum.PARK_FREEBERTH_PLNO_FREEBERTH_TOPIC.key(),jsonObject);
			}
		}catch(Exception e){
			logger.error("根据停车场编号["+plNo+"]更新空闲车位报错：",e);
		}
		return idleberth;
	}
	/**
	 * 更新redis中空闲车位数，返回当前总的空闲车位数
	 * @param type	1：进场；2：出场
	 * @param info
	 * @param parkNo 自己内部停车场编号
	 * @param fromType  1：艾润；2：青岛
	 * @return
	 * 2017年6月7日 zhaowg
	 */
	private Integer updateRedisFreeBerthNum(Integer type, String parkNo,Integer fromType,Integer freeBerths) {
		//通过来源类型判断更新空闲车位的方式，直接覆盖还是自己计算
		String updateFreeMethods = SysCodeValueCacheUtil.queryCodeNameByCodeValue(CodeValKindEnum.UPDATE_FREEBERTHS_BY_FROMTYPE,fromType.toString());
		if(StringUtils.isBlank(updateFreeMethods)){
			logger.error("通过来源类型【"+fromType+"】从缓存中获取对应的更新空闲车位方式失败。",new Exception("通过来源类型判断更新空闲车位的方式失败，没有找到来源类型【"+fromType+"】对应的更新空闲车位方式"));
			return 0;
		}
		BizResult<Integer> bizResult = new BizResult<>();
		//直接覆盖
		if(updateFreeMethods.equals(ParkConstant.ParkFreeBerths.UpdateMethod.COVER)){
			FreeBerthNumUpdateByFreeBerthNumRequest request = new FreeBerthNumUpdateByFreeBerthNumRequest();
			request.setFreeBerthNum(freeBerths);
			request.setPlNo(parkNo);
			request.setSysCode(sysCode);
			bizResult = parkFreeBerthService.updateFreeBerthNumByFreeBerthNum(request );
		}else if(updateFreeMethods.equals(ParkConstant.ParkFreeBerths.UpdateMethod.AUTOCALC)){
			//自己计算
			FreeBerthNumUpdateByInOutTypeRequest request = new FreeBerthNumUpdateByInOutTypeRequest();
			request.setInOutType(type);
			request.setPlNo(parkNo);
			request.setSysCode(sysCode);
			bizResult = parkFreeBerthService.updateFreeBerthNumByInOutType(request);
		}
		
		return ResultUtils.getBizResultData(bizResult);
	}
}
