package com.zteits.irain.portal.service.impl.inoutparklot;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSON;
import com.clouds.common.cache.park.ParkingLotCacheUtil;
import com.clouds.common.utils.BeanValidatorsUtils;
import com.clouds.common.utils.ResultUtils;
import com.zteits.clouds.api.apibase.bean.BaseInfo;
import com.zteits.clouds.api.apibase.bean.BizResult;
import com.zteits.clouds.api.apibase.exception.BizException;
import com.zteits.clouds.api.dto.park.dto.ParkingLotDTO;
import com.zteits.clouds.api.dto.park.param.InParkingRequest;
import com.zteits.clouds.api.dto.park.param.OutParkingRequest;
import com.zteits.clouds.api.dto.park.param.QueryParkLotInfoByPkOutNoRequest;
import com.zteits.clouds.api.dto.park.param.UpdateParkingPlaceStatusRequest;
import com.zteits.clouds.api.service.park.IInOutParkingService;
import com.zteits.clouds.api.service.park.ParkingLotBerthsService;
import com.zteits.clouds.api.service.park.ParkingLotQueryService;
import com.zteits.clouds.api.service.pay.ParkOrderService;
import com.zteits.irain.portal.constant.ParkConstant;
import com.zteits.irain.portal.constant.ParkConstant.InterfaceLog;
import com.zteits.irain.portal.service.interfaces.inoutparklot.InOutParkLotReportService;
import com.zteits.irain.portal.service.interfaces.inoutparklot.param.RecordInParkLotRequest;
import com.zteits.irain.portal.service.interfaces.inoutparklot.param.RecordOutParkLotRequest;
import com.zteits.irain.portal.service.interfaces.parklotidleberths.ParkLotIdleBerthsService;

@Component
public class InOutParkLotReportServiceImpl implements InOutParkLotReportService {
	
	private static final Logger logger = LoggerFactory.getLogger(InOutParkLotReportServiceImpl.class);
	@Value("${project.syscode}")
	private String sysCode;
	/**进出场记录*/
	@Autowired
	private IInOutParkingService iInOutParkingService;
	/**停车场订单service*/
	@Autowired
	private ParkOrderService parkOrderService;
	/**空闲车位*/
	@Autowired
	private ParkLotIdleBerthsService lotIdleBerthsService;
	@Autowired
	private ParkingLotQueryService parkingLotQueryService;
	
	/**
	 * 车位操作服务
	 */
	@Autowired
	private ParkingLotBerthsService parkinglotBerthsService;
	
	@Override
	public Long InParkLotRecord(RecordInParkLotRequest request) throws Exception {
		BeanValidatorsUtils.validateWithException(request);
		BaseInfo baseInfo = new BaseInfo();

		InParkingRequest InParkingRequest = request.getInParkLotReq();
		InParkingRequest.setBaseRequest(baseInfo);
		InParkingRequest.setSysCode(request.getSysCode());
		InParkingRequest.setFromType(request.getFromType());
		InParkingRequest.setSourceType(request.getSourceType());
		//设置停车场编号和名称
		ParkingLotDTO parkingLotDTO = this.getOurParkLotInfoByOutNo(request.getInParkLotReq().getParkCode());
		InParkingRequest.setPlNo(parkingLotDTO.getPlNo());
		InParkingRequest.setPlName(parkingLotDTO.getPlName());
		logger.info("更新空闲车位");
		int totalFreeBerths = lotIdleBerthsService.updateAndGetIdleBerthByParkNo(InParkingRequest.getInTime(),InParkingRequest.getPlNo(), ParkConstant.InterfaceLog.Type.TYPE_IN_PARKING,
				InParkingRequest.getFromType(), InParkingRequest.getFreeBerths());
		//设置总空闲车位数
		InParkingRequest.setFreeBerths(totalFreeBerths);
		
		logger.info("记录进场日志请求参数："+JSON.toJSON(InParkingRequest));
		BizResult<Long> bizResult = iInOutParkingService.SaveIRainInParking(InParkingRequest);
		
		logger.info("插入停车订单--begin----");
		BizResult<String> orderResult = parkOrderService.insertParkingOrder(InParkingRequest);
		logger.info("插入停车订单--end----结果=[errorMsg={},orderId={}]",orderResult.getErrMsg(),orderResult.getData());
		// 数据来源青岛,则更新进场车位状态
		if (InterfaceLog.FromType.QINGDAO == request.getFromType()) {
			updateBerthsStatus(baseInfo, InParkingRequest.getParkCode(),InParkingRequest.getParkingPlaceCode(),InParkingRequest.getParkingPlaceStatus());
			try {
				//特殊停车场的车位更新以及空闲车位数量更新
				this.updateBerthsNum(baseInfo, InParkingRequest.getParkCode(), InParkingRequest.getParkingPlaceCode(), InParkingRequest.getParkingPlaceStatus());
			} catch (Exception e) {
				logger.error("特殊停车场的车位更新以及空闲车位数量更新异常！",e);
			}
		}

		if(!orderResult.isSuccess()){
			throw new BizException(orderResult.getErrCode(), orderResult.getErrMsg());
		}
		
		if(!bizResult.isSuccess()){
			throw new BizException(bizResult.getErrCode(), bizResult.getErrMsg());
		}
		return bizResult.getData();
	}
	/**
	 * 更新空闲车位
	 * @param baseInfo
	 * @param foreignParkinglotNo
	 * @param foreignParkingPlaceNo
	 * @param parkingPlaceStatus
	 */
	private void updateBerthsStatus(BaseInfo baseInfo, String foreignParkinglotNo,String foreignParkingPlaceNo,Integer parkingPlaceStatus) {
		logger.info("数据来源青岛,则更新出场车位状态");
		UpdateParkingPlaceStatusRequest updateRequest = new UpdateParkingPlaceStatusRequest();
		updateRequest.setBaseRequest(baseInfo);
		updateRequest.setSysCode(sysCode);
		updateRequest.setForeignParkinglotNo(foreignParkinglotNo);
		updateRequest.setForeignParkingPlaceNo(foreignParkingPlaceNo);
		updateRequest.setParkingPlaceStatus(parkingPlaceStatus);

		BizResult<Boolean> updateResult = parkinglotBerthsService.UpdateParkingPlaceStatus(updateRequest);
		
		if (!updateResult.isSuccess()) {
			throw new BizException(updateResult.getErrCode(), updateResult.getErrMsg());
		}
	}

	@Override
	public Long OutParkLotRecord(RecordOutParkLotRequest request) throws Exception{
		BeanValidatorsUtils.validateWithException(request);
		BaseInfo baseInfo = new BaseInfo();

		OutParkingRequest OutParkingRequest = request.getOutParkLotReq();
		OutParkingRequest.setBaseRequest(baseInfo);
		OutParkingRequest.setSysCode(request.getSysCode());
		OutParkingRequest.setFromType(request.getFromType());
		OutParkingRequest.setSourceType(request.getSourceType());
		//根据外部停车场编号获取自己的停车场编号和名称
		ParkingLotDTO parkingLotDTO = this.getOurParkLotInfoByOutNo(request.getOutParkLotReq().getParkCode());
		OutParkingRequest.setPlNo(parkingLotDTO.getPlNo());
		OutParkingRequest.setPlName(parkingLotDTO.getPlName());
		
		logger.info("更新空闲车位");
		int totalFreeBerths = lotIdleBerthsService.updateAndGetIdleBerthByParkNo(OutParkingRequest.getOutTime(),OutParkingRequest.getPlNo(), ParkConstant.InterfaceLog.Type.TYPE_OUT_PARKING, 
				request.getFromType(), OutParkingRequest.getFreeBerths());
		//设置总空闲车位数
		OutParkingRequest.setFreeBerths(totalFreeBerths);
		
		logger.info("记录出车日志请求参数："+JSON.toJSONString(OutParkingRequest));
		BizResult<Long> bizResult = iInOutParkingService.SaveIRainOutParking(OutParkingRequest);
		logger.info("记录出车日志响应信息："+JSON.toJSONString(bizResult));
		
		logger.info("出车上报更新停车订单.");
		BizResult<String> orderResult = parkOrderService.updateParkingOrder(OutParkingRequest);
		logger.info("出车上报更新订单响应信息："+JSON.toJSONString(orderResult));
				
		// 数据来源青岛,则更新出场车位状态
		if (InterfaceLog.FromType.QINGDAO == request.getFromType()) {
			logger.info("数据来源青岛,则更新出场车位状态");
			this.updateBerthsStatus(baseInfo, OutParkingRequest.getParkCode(), OutParkingRequest.getParkingPlaceCode(), OutParkingRequest.getParkingPlaceStatus());
			try {
				//特殊停车场的车位更新以及空闲车位数量更新
				//20170714 zhaowg 目前没有特殊停车场，不考虑
				//this.updateBerthsNum(baseInfo, OutParkingRequest.getParkCode(), OutParkingRequest.getParkingPlaceCode(), OutParkingRequest.getParkingPlaceStatus());
			} catch (Exception e) {
				logger.error("特殊停车场的车位更新以及空闲车位数量更新异常！",e);
			}
		}
		
		
		if(!orderResult.isSuccess()){
			throw new BizException(bizResult.getErrCode(), bizResult.getErrMsg());
		}
		if(!bizResult.isSuccess()){
			throw new BizException(bizResult.getErrCode(), bizResult.getErrMsg());
		}
		
		return bizResult.getData();
	}
	
	/**
	 * 根据上报的停车场查询对应的我们自己的停车场信息 
	 * @param parkCode
	 * @return
	 * 2017年6月7日 zhaowg
	 */
	private ParkingLotDTO getOurParkLotInfoByOutNo(String parkCode) {
		logger.info("根据上报的停车场编号["+parkCode+"]查询对应的我们自己的停车场编号");
		//先查询缓存
		ParkingLotDTO parkingLotDTO = ParkingLotCacheUtil.getParkLotByPlOutNo(parkCode);
		if(parkingLotDTO != null){
			return parkingLotDTO;
		}
		//查询数据库
		logger.info("根据上报的停车场编号["+parkCode+"]在缓存总没有查询到对应的停车场信息，开始查询数据库");
		QueryParkLotInfoByPkOutNoRequest request = new QueryParkLotInfoByPkOutNoRequest();
		request.setSysCode(sysCode);
		request.setPklOutNo(parkCode);
		BizResult<ParkingLotDTO> bizResult = parkingLotQueryService.QueryParkingLotByPkOutNo(request );
		parkingLotDTO = ResultUtils.getBizResultData(bizResult);
		return parkingLotDTO;
	}

	/**
	 * 更新park_free_berth表中空闲车位个数(特殊)
	 * @param baseInfo
	 * @param foreignParkinglotNo
	 * @param foreignParkingPlaceNo
	 * @param parkingPlaceStatus
	 */
	private void updateBerthsNum(BaseInfo baseInfo, String foreignParkinglotNo,String foreignParkingPlaceNo,Integer parkingPlaceStatus) {
		logger.info("数据来源青岛,则更新出场车位状态以及空闲停车位个数");
		UpdateParkingPlaceStatusRequest updateRequest = new UpdateParkingPlaceStatusRequest();
		updateRequest.setBaseRequest(baseInfo);
		updateRequest.setSysCode(sysCode);
		updateRequest.setForeignParkinglotNo(foreignParkinglotNo);
		updateRequest.setForeignParkingPlaceNo(foreignParkingPlaceNo);
		updateRequest.setParkingPlaceStatus(parkingPlaceStatus);

		BizResult<Boolean> updateResult = parkinglotBerthsService.updateFreeBerthNum(updateRequest);
		
		if (!updateResult.isSuccess()) {
			throw new BizException(updateResult.getErrCode(), updateResult.getErrMsg());
		}
	}
}
