package com.zteits.irain.portal.service.impl.induction;

import java.util.HashMap;
import java.util.Map;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import com.alibaba.fastjson.JSONObject;
import com.clouds.common.web.vo.BizResultVO;
import com.zteits.clouds.api.apibase.constants.ErrorType;
import com.zteits.irain.portal.common.HttpClientTutorial;
import com.zteits.irain.portal.service.interfaces.induction.InductionService;
import com.zteits.irain.portal.service.interfaces.induction.param.DoLevelTwoAndThreeInductionReleaseBatchRequest;
import com.zteits.irain.portal.service.interfaces.induction.param.InductionLevelOneShow;
import com.zteits.irain.portal.service.interfaces.induction.param.InductionResponse;

/**
 * 对接智慧停车诱导服务管理系统
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: InductionService.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年5月24日   上午9:28:48 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年5月24日      zhaowg              v1.0.0               创建
 */
@Component
public class InductionServiceImpl implements InductionService{

	private static final Logger logger = LoggerFactory.getLogger(InductionServiceImpl.class);
	
	/**一级诱导回显地址*/
	@Value("${induction.showLevelOneInductionReleaseUrl}")
	private String showLevelOneInductionReleaseUrl;
	
	/**二级三级诱导批量发布地址*/
	@Value("${induction.doLevelTwoAndThreeInductionReleaseBatchUrl}")
	private String doLevelTwoAndThreeInductionReleaseBatchUrl;
	
	@Override
	public BizResultVO<?> doLevelTwoAndThreeInductionReleaseBatch(DoLevelTwoAndThreeInductionReleaseBatchRequest request) {
		logger.info("开始调用二级、三级诱导批量发布接口");
		BizResultVO<?> result = new BizResultVO<>();
		try {
			Map<String, Object> params = new HashMap<>();
			params.put("owner_code", request.getOwner_code());
			params.put("pwd", request.getPwd());
			params.put("jsonStr", JSONObject.toJSONString(request.getJsonStr()));
			logger.info("二级、三级诱导批量发布接口地址："+doLevelTwoAndThreeInductionReleaseBatchUrl);
			logger.info("二级、三级诱导批量发布接口请求参数:" + JSONObject.toJSONString(params));
			String rs = HttpClientTutorial.httpPostRequest(doLevelTwoAndThreeInductionReleaseBatchUrl, params);
			logger.info("二级、三级诱导批量发布接口响应参数:" + rs);
			InductionResponse inductionResponse = JSONObject.parseObject(rs, InductionResponse.class);
			String code = inductionResponse.getSys_code();
			if("100".equals(code)){
				result.setCode(ErrorType.BIZ_SUCCESS.getCode());
				result.setMsg(ErrorType.BIZ_SUCCESS.getMsg());
			}else{
				result.setCode(code);
				result.setMsg(inductionResponse.getSys_msg());
			}
			
		} catch (Exception e) {
			logger.error("调用二级、三级诱导批量发布接口报错:",e);
			result.setCode(ErrorType.BIZ_ERROR.getCode());
			result.setMsg(ErrorType.BIZ_ERROR.getMsg());
		}
		logger.info("调用二级、三级诱导批量发布接口成功,返回封装后的数据："+JSONObject.toJSONString(result));
		return result;
	}

	@Override
	public BizResultVO<InductionLevelOneShow> showLevelOneInductionRelease(String eqpCode) {
		logger.info("开始调用一级诱导发布回显接口");
		BizResultVO<InductionLevelOneShow> result = new BizResultVO<>();
		try {
			Map<String, Object> params = new HashMap<>();
			//TODO accessToken获取
			params.put("accessToken", "ffa51bdd90e86577812dddff0829941ca9");
			params.put("eqpCode", eqpCode);
			logger.info("一级诱导发布回显接口地址："+showLevelOneInductionReleaseUrl);
			logger.info("一级诱导发布回显接口请求参数:" + JSONObject.toJSONString(params));
			String rs = HttpClientTutorial.httpPostRequest(showLevelOneInductionReleaseUrl, params);
			logger.info("一级诱导发布回显接口响应参数:" + rs);
			InductionResponse inductionResponse = JSONObject.parseObject(rs, InductionResponse.class);
			
			String code = inductionResponse.getSys_code();
			if("100".equals(code)){
				result.setCode(ErrorType.BIZ_SUCCESS.getCode());
				result.setMsg(ErrorType.BIZ_SUCCESS.getMsg());
				//获取数据
				String dataStr = JSONObject.toJSONString(inductionResponse.getData());
				InductionLevelOneShow inductionLevelOneShow = JSONObject.parseObject(dataStr, InductionLevelOneShow.class);
				result.setData(inductionLevelOneShow);
			}else{
				result.setCode(code);
				result.setMsg(inductionResponse.getSys_msg());
			}
			
		} catch (Exception e) {
			logger.error("调用一级诱导发布回显接口报错:",e);
			result.setCode(ErrorType.BIZ_ERROR.getCode());
			result.setMsg(ErrorType.BIZ_ERROR.getMsg());
		}
		logger.info("调用一级诱导发布回显接口成功,返回封装后的数据："+JSONObject.toJSONString(result));
		return result;
	}
}
