package com.zteits.irain.portal.constant;

import java.util.HashMap;
import java.util.Map;

public class ParkConstant {
	/**接口表相关常量*/
	public static class InterfaceLog{
		
		public static class Type{
			/**进场*/
			public static final int TYPE_IN_PARKING = 1;
			/**出场*/
			public static final int TYPE_OUT_PARKING = 2;
		}
		
		public static class Status{
			/**成功*/
			public static final Byte SUCCESS = 1;
			/**失败*/
			public static final Byte FAIL = 0;
		}
		
		public static class FromType{
			/**艾润*/
			public static final int IRAIN = 1;
			/**青岛*/
			public static final int QINGDAO = 2;
			/**捷商*/
			public static final int JIESHANG =3;
		}
		
		public static class SourceType{
			/**道闸*/
			public static final int GATEWAY = 1;
			/**地磁*/
			public static final int GEO = 2;
		}
	}
	
	/**停车场经纬度表相关常量*/
	public static class ParkingLotGeo{
		
		public static class GeoType{
			/**停车场坐标*/
			public static final int TYPE_PARKINGLOT = 1;
			/**停车场入口坐标*/
			public static final int TYPE_PARKINGLOT_IN = 2;
		}
		
	}
	public static class ParkingLotUseStatistic{
		//统计类型：1：每20分钟；2：每1小时；3：每天
		public static class StatisticType{
			public static final int PER20MINUTE = 1;
			public static final int PER1HOUR = 2;
			public static final int PER1DAY = 3;
		}
		//比率：1：空置率，2：周转率
		public static class BerthRatioType{
			public static final int FREE = 1;
			public static final int TURNOVER = 2;
		}
	}
	/**青岛进出场上报相关常量*/
	public static class QDInOutParkLot{
		public static class InOutType{
			/**进场*/
			public static final String INPARKLOT ="1";
			/**出场-正常*/
			public static final String OUTPARKLOT_NOMAL = "2";
			/**出场-逃逸*/
			public static final String OUTPARKLOT_ESCAPE = "3";
		}
	}
	/**停车场设备表相关常量*/
	public static class ParkingLotEqp{
		
		public static class EqpType{
			/**地磁*/
			public static final int GEO = 1;
			/**pos机*/
			public static final int POS = 2;
		}
		
	}
	/**空闲车位表相关常量*/
	public static class ParkFreeBerths{
		/**更新空闲车位方式*/
		public static class UpdateMethod{
			/**自己根据进出场计算*/
			public static final String AUTOCALC = "AUTOCALC";
			/**根据上报的空闲车位直接覆盖*/
			public static final String COVER = "COVER";
		}
	}
	/**城市ID*/
	public static class CityId{
		/**赤峰*/
		public static final Long CHIFENG = 91L;
	}
}
