package com.zteits.irain.portal.config.filter;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

/**
 * 添加响应统一请求头
 * 
 * Copyright: Copyright (c) 2017  zteits
 * 
 * @ClassName: ResponseHeaderFilter.java
 * @Description: 
 * @version: v1.0.0
 * @author: zhaowg
 * @date: 2017年5月8日   下午3:17:18 
 * Modification History: 
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年5月8日      zhaowg              v1.0.0               创建
 */
public class ResponseHeaderFilter implements Filter{
	
	@Override
	public void doFilter(ServletRequest request, ServletResponse response,
			FilterChain chain) throws IOException, ServletException {
		HttpServletResponse res = (HttpServletResponse) response;
		res.addHeader("Access-Control-Allow-Origin", "*");
		res.addHeader("Access-Control-Allow-Methods", "GET, POST, DELETE, PUT");
		res.addHeader("Access-Control-Allow-Headers", "Content-Type, X-Auth-Token, x-requested-with ,Authorization");
		chain.doFilter(request, response);
	}
	
	@Override
	public void destroy() {
	}
	
	@Override
	public void init(FilterConfig filterConfig) throws ServletException {
	}
}
