package com.zteits.irain.portal;



import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.context.embedded.EmbeddedServletContainerFactory;
import org.springframework.boot.context.embedded.tomcat.TomcatEmbeddedServletContainerFactory;
import org.springframework.boot.web.servlet.ServletComponentScan;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.context.annotation.EnableAspectJAutoProxy;
import org.springframework.context.annotation.FilterType;
import org.springframework.context.annotation.ImportResource;
import org.springframework.context.annotation.ComponentScan.Filter;

import com.clouds.common.web.WebMvcConfigurer;

/**
 * 
 * Copyright: Copyright (c) 2017  ZTE-ITS
 * 
 * @ClassName: IRainPortalApplication.java
 * @Description: 
 * @version: v1.0.0
 * @author: wangbiao
 * @date: 2017年4月20日   上午11:44:00 
 * Modification History:
 * Date             Author          Version            Description
 *---------------------------------------------------------*
 * 2017年4月20日      wangbiao           v1.0.0               创建
 */
@SpringBootApplication
@ImportResource(value={"classpath:dubbo/dubbo-park-consumer.xml"})
@EnableAspectJAutoProxy
@ComponentScan(basePackages={"com.zteits.irain.portal","com.clouds.common.redis","com.clouds.common.web"},excludeFilters={@Filter(type=FilterType.ASSIGNABLE_TYPE,value=WebMvcConfigurer.class)}) 
public class ParkPortalApplication {

    public static void main(String[] args) {
        SpringApplication.run(ParkPortalApplication.class, args);
        
        
    }
    @Bean
    public EmbeddedServletContainerFactory servletContainer() {
        TomcatEmbeddedServletContainerFactory factory =
                new TomcatEmbeddedServletContainerFactory();
         return factory;
    }
    
    

}