// 1. 先导入必要依赖（注意顺序）
import App from './App'
import uviewPlus from '@/uni_modules/uview-plus'
// 导入 Pinia 实例（你的 stores/index.js 导出的 pinia）
import pinia from '@/pinia/index'
import EmptyView from '@/components/empty-view/empty-view.vue';
import UploadImage from '@/components/upload-image/upload-image.vue';
import dictUtils from '@/common/utils/dict';
// #ifdef VUE3
import { createSSRApp } from 'vue'
// 挂载到uni全局
uni.$dict = dictUtils;
export function createApp() {
  // 2. 创建 Vue 实例
  const app = createSSRApp(App)

  // 3. 注册 uviewPlus（保持原有逻辑）
  app.use(uviewPlus)

  // 4. 注册 Pinia（核心：在 app 挂载前注册）
  app.use(pinia)
  // 全局注入字典工具（关键：provide需在app实例上注册）
  // app.provide('$dict', dictUtils);
  app.component('EmptyView', EmptyView)
  app.component('UploadImage', UploadImage)
  // 5. 返回 app + pinia（可选，便于调试）
  return {
    app,
    pinia
  }
}
// #endif


