// @/common/utils/upload.ts
import globalConfig from '@/common/config/global';
import cache from '@/common/utils/cache';
import { useUserStore } from '@/pinia/user';
import { fileUpload } from '@/api/common';

// 统一的多文件上传方法（单/多图都走这个）
export const uploadImages = async (options) => {
  const {
    filePaths,
    fileKey = 'file',
    header = {},
    ignoreError = true // 忽略单张失败，继续上传其他
  } = options;

  if (!filePaths || filePaths.length === 0) {
    uni.showToast({title: '请选择要上传的图片', icon: 'none'});
    return [];
  }

  const userStore = useUserStore()
  const defaultHeader = {
    'Content-Type': 'multipart/form-data',
    'Authorization': 'Bearer ' + (userStore.token || cache.get(globalConfig.cache.tokenKey) || '')
  };
  const finalHeader = {...defaultHeader, ...header};
  const resultUrls = []; // 最终返回的URL数组

  // 遍历上传（单/多图统一遍历逻辑）
  for (let i = 0; i < filePaths.length; i++) {
    try {
      const url = await new Promise((resolve, reject) => {
        uni.uploadFile({
          url: `${globalConfig.api.baseUrl}${fileUpload}`,
          filePath: filePaths[i],
          name: fileKey,
          header: finalHeader,
          success: (res) => {
            try {
              const data = JSON.parse(res.data);
              if (data.code === 0) {
                resolve(data.data); // 接口返回的URL在data.data中
              } else {
                reject(new Error(data.msg || '上传失败'));
              }
            } catch (e) {
              reject(new Error('解析返回数据失败'));
            }
          },
          fail: (err) => {
            reject(new Error(err.errMsg || '网络错误'));
          }
        });
      });
      resultUrls.push(url); // 成功的URL加入数组
    } catch (err) {
      console.error(`第${i+1}张图片上传失败：`, err);
      if (!ignoreError) break; // 不忽略错误则终止上传
    }
  }

  return resultUrls; // 始终返回数组（单图返回长度1，多图返回对应长度，无成功则返回空数组）
};