export default {
  set(key, value, expire = 0) {
    const data = {
      value,
      expire: expire ? Date.now() + expire : 0
    };
    uni.setStorageSync(key, JSON.stringify(data));
  },

  get(key) {
    try {
      const data = JSON.parse(uni.getStorageSync(key));
      if (data.expire && data.expire < Date.now()) {
        this.remove(key);
        return null;
      }
      return data.value;
    } catch (e) {
      return null;
    }
  },

  remove(key) {
    uni.removeStorageSync(key);
  },

  clear() {
    uni.clearStorageSync();
  }
};