import env from './env';

export default {
  api: {
    baseUrl: env.baseUrl,
    uploadUrl: env.uploadUrl,
    // baseApi: env.baseApi || 'admin-api',  // 默认前缀：admin-api
    // appApi: env.appApi || 'app-api',       // 特殊前缀：app-api
    timeout: 10000,
    tokenKey: 'jcss_token'
  },
  router: {
    loginPath: '/pages/login/index',
    tabBarList: [
      { path: '/pages/index/index', name: '首页' },
      { path: '/pages/workbench/index', name: '工作台' },
      { path: '/pages/mine/index', name: '我的' }
    ]
  },
  cache: {
    userInfoKey: 'jcss_user_info',
    tokenKey: 'jcss_token',
    expireTimeKey: 'jcss_token_expire',
    userIdKey:'jcss_user_id',
    moduleListKey:'jcss_module_list',
    dictDataKey:'jcss_dict_data'
  },
  appName: 'JCSS管理系统',
  tokenExpireTime: 7 * 24 * 60 * 60 * 1000
};