// api/workbench.js - 补全所有导出方法
import { get } from '@/common/utils/request';

/**
 * 获取日常管理菜单（适配登录用户权限）
 * @returns {Promise}
 */
export const getDailyManageMenu = () => {
  return get('/workbench/dailyManage');
};

/**
 * 获取问题管理菜单（适配登录用户权限）
 * @returns {Promise}
 */
export const getProblemManageMenu = () => {
  return get('/workbench/problemManage');
};

/**
 * 获取数据管理菜单（固定菜单，也可改为接口获取）
 * @returns {Promise}
 */
export const getDataManageMenu = () => {
  return get('/workbench/dataManage');
};

/**
 * 获取行道树档案列表（分页）
 * @param {Object} params {pageNo, pageSize}
 * @returns {Promise}
 */
export const getTreeArchiveList = (params) => {
  return get('/workbench/treeArchive', params);
};