// api/user.js
import { post, get } from '@/common/utils/request';

/**
 * 登录接口
 * @param {Object} params {mobile, password, code}
 * @returns {Promise}
 */
export const login = (params) => {
  return post('/admin-api/system/auth/login', params);
};

/**
 * 获取用户信息
 * @returns {Promise}
 */
export const getUserInfo = () => {
  return get('/admin-api/system/auth/get-permission-info');
};

/**
 * 退出登录
 * @returns {Promise}
 */
export const logout = () => {
  return post('/admin-api/system/auth/logout');
};

/**
 * 模块列表用这个
 * @returns {Promise}
 */
export const moduleList = () => {
  return get('/app-api/member/app-module/list');
};

/**
 * 字典数据
 * @returns {Promise}
 */
export const getSimpleDictDataList = () => {
  return get('/admin-api/system/dict-data/simple-list')
}
